package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

import com.ejie.p06b.datatype.model.P06B34T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * Fecha de creacin: (05/07/2010)
 */
public class P06B34T00DAO {
	
	static private P06B34T00DAO instance = null;

	public static P06B34T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B34T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B34T00DAO();
	                }
	          }
	     }
	     return instance;
	}
	
	
	/**
    * Obtiene la lista de cargos de admins y direc DEC asociados al expediente y ejercicio
    * @param ejer.
    * @param numExp          
    * @return Lista de objetos cargos DEC
	 * @throws Exception
    */
	public ArrayList selectAllByEjerExp(String ejer, String numExp) throws Exception{
		P06BLog.send(2,this, "Inicio P06B34T00DAO-selectAllByEjerExp");
		ArrayList lista = new ArrayList();
		P06B34T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_EJEREXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejer.toUpperCase());
        	lstm.setString(2,numExp.toUpperCase());
        	lrst = lstm.executeQuery();
	        while (lrst.next()) {
	        	obj = new P06B34T00Datatype();
	       
	        	obj.setEjercicio(lrst.getString(P06BTablas.P06B_P06B34_EJERCICIO));
	        	obj.setTipo(lrst.getString(P06BTablas.P06B_P06B34_TIPO));
			    obj.setNumExp(lrst.getString(P06BTablas.P06B_P06B34_NUMEXP));
			    obj.setIdentificador(lrst.getString(P06BTablas.P06B_P06B34_IDENTIFICADOR));
			    obj.setNombre(lrst.getString(P06BTablas.P06B_P06B34_NOMBRE)==null?"":lrst.getString(P06BTablas.P06B_P06B34_NOMBRE));
			    obj.setApe1(lrst.getString(P06BTablas.P06B_P06B34_APE1)==null?"":lrst.getString(P06BTablas.P06B_P06B34_APE1));
			    obj.setApe2(lrst.getString(P06BTablas.P06B_P06B34_APE2)==null?"":lrst.getString(P06BTablas.P06B_P06B34_APE2));
			    obj.setFechNom(lrst.getString(P06BTablas.P06B_P06B34_FECHNOM)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B34_FECHNOM),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    obj.setIdCargo(lrst.getString(P06BTablas.P06B_P06B34_IDCARGO)==null?"":lrst.getString(P06BTablas.P06B_P06B34_IDCARGO));
	        	
	        	lista.add(obj);
	        }
	        P06BLog.send(2,this, "Fin P06B34T00DAO-selectAllByEjerExp");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return lista;
	}
	
	
	private static String SELECTALL_BY_EJEREXP =
		"SELECT "
		+ P06BTablas.P06B_P06B34_EJERCICIO + ", "
		+ P06BTablas.P06B_P06B34_TIPO + ", "
		+ P06BTablas.P06B_P06B34_NUMEXP + ", "
		+ P06BTablas.P06B_P06B34_IDENTIFICADOR + ", "
		+ P06BTablas.P06B_P06B34_NOMBRE + ", "
		+ P06BTablas.P06B_P06B34_APE1 + ", "
		+ P06BTablas.P06B_P06B34_APE2 + ", "
		+ P06BTablas.P06B_P06B34_FECHNOM + ", "
		+ P06BTablas.P06B_P06B34_IDCARGO +
		" FROM " + P06BTablas.P06B_P06B34T00_TABLA 
		+ " WHERE " + P06BTablas.P06B_P06B34_EJERCICIO + "= ?" 
			+ " AND " + P06BTablas.P06B_P06B34_NUMEXP + "= ?"
		+" ORDER BY " + P06BTablas.P06B_P06B34_IDENTIFICADOR ;

	
}
